# 5 High-Value AI Prompts for Modern Marketers

These prompts use advanced prompt engineering structures (Role-Play, Frameworks, and Constraints) to help you generate high-converting, human-sounding content.

---

## 1. The "Delete Test" Email Auditor
**Goal:** Identify exactly where an email loses the reader and how to fix it.
**Structure:** Role-Play Simulation & Critical Analysis

 **Prompt:**
 Act as a busy, skeptical C-level executive checking emails on a mobile phone between meetings. You have zero tolerance for fluff, irrelevant intros, or confusing formatting.
 
 Analyze the email copy provided below and perform the "Delete Test":
 1. **The Drop-Off Point:** Mark the exact sentence or phrase where you would stop reading and delete the email. Explain *why* (e.g., "boredom," "confusing ask," "looks like spam").
 2. **The 3-Second Scan:** Tell me what, if anything, you absorbed in the first 3 seconds of looking at the email.
 3. **The Fix:** Rewrite the problematic sections to save the email from the trash. Make the hook sharper, the value obvious, and the ask crystal clear.
 
 **Input Email:**
 [Paste your email draft here]

---

## 2. The "Anti-Bot" Content Humanizer
**Goal:** Strip away generic AI-sounding language and corporate fluff.
**Structure:** Style & Constraint-Based Editing

 **Prompt:**
 You are a ruthless editor for a high-end publication known for hating "corporate speak" and "AI-generated fluff." Your job is to audit the content below and brutally remove anything that sounds generic or robotic.
 
 **Follow these strict editing rules:**
 * **Ban List:** Flag and replace words like "delve," "landscape," "unleash," "elevate," "game-changer," and "tapestry."
 * **Specificity Check:** If a sentence could apply to *any* industry (e.g., "Improve your efficiency with our solution"), rewrite it to be radically specific to [Insert Industry/Niche].
 * **Sentence Variety:** Break up repetitive "Subject-Verb-Object" cadences with short, punchy sentence fragments or questions.
 * **The "So What?" Test:** For every claim made, ask "So what?" If the text doesn't answer it, rewrite it to focus on a tangible outcome.
 
 **Content to Audit:**
 [Paste content here]

---

## 3. The "PAS" Framework Email Generator
**Goal:** Generate high-converting cold outreach using psychological triggers.
**Structure:** Framework-Based (Problem-Agitation-Solution)

 **Prompt:**
 Write a cold outreach email targeting [Job Title/Persona] using the **PAS (Problem-Agitation-Solution)** framework.
 
 **Structure the email exactly as follows:**
 1. **Problem (The Hook):** Open by identifying a specific, painful problem they are facing right now. Do *not* start with "I hope this email finds you well." Start with the pain.
 2. **Agitation (The Twist):** Twist the knife. Explain the cost of ignoring this problem (e.g., lost revenue, wasted time, team burnout). Make it feel urgent.
 3. **Solution (The Bridge):** Introduce [Product/Service Name] as the specific remedy to that exact pain.
 4. **Call to Action (The Ask):** End with a "low friction" CTA (e.g., "Worth a conversation?" or "Open to a 2-minute video?").
 
 **Key Variables:**
 * **Product/Service:** [Insert Product]
 * **Target Pain Point:** [Insert Pain Point]

---

## 4. The LinkedIn "Scroll-Stopper" Ghostwriter
**Goal:** Create viral-style LinkedIn posts that maximize "See More" clicks.
**Structure:** Formatting-Centric Roleplay

 **Prompt:**
 Act as a LinkedIn Top Voice ghostwriter who specializes in high-engagement content. Your goal is to turn a rough idea into a scroll-stopping post.
 
 **Create a LinkedIn post based on [Topic/Idea] using this structure:**
 1. **The Hook (Lines 1-2):** A contrarian statement, a surprising statistic, or a vulnerable admission. This MUST force the user to click "See more."
 2. **The Meat (Body):** Break the concept down into punchy bullet points. Use whitespace generously (maximum one sentence per paragraph).
 3. **The Takeaway:** A one-line summary of the lesson learned.
 4. **The Engagement Ask (P.S.):** A specific question to drive comments (e.g., "Which of these 3 is your biggest bottleneck?").
 
 **Constraint:** Keep it under 1,200 characters. Use zero hashtags in the body text.

---

## 5. The "Angle Extractor" Newsletter Generator
**Goal:** Repurpose one blog post into three distinct newsletter issues.
**Structure:** Content Transformation

 **Prompt:**
 I want to repurpose the blog post below into 3 *distinct* newsletter emails. Do not just summarize the post. Instead, extract 3 different "lenses" to present the content:
 
 1. **The "Mistake" Angle:** Frame the content around a common mistake the reader is making and how the blog post solves it. 
 2. **The "Story" Angle:** Pull a specific example, case study, or anecdote from the text and use it as the lead. The blog post is the "moral" of the story.
 3. **The "Checklist" Angle:** Strip the content down to a raw, actionable checklist or "cheat sheet" value-add.
 
 **Blog Post Content:**
 [Paste blog post text or URL]
