---
tags:
- marketing
- copywriting
- linkedin
- email
- editing
- prompts
---

# Marketing Prompts Collection v3

Created by: Gemini
Category: Lead Magnet Assets

This collection contains 5 advanced prompts designed for modern marketers. These prompts utilize specific frameworks (Behavioral Psychology, Editorial Strategy, Attention Economics) to generate high-quality, non-generic outputs.

---

## 1. The "Behavioral Trigger" Email Generator

**Purpose:** Generating better email copy.
**Mechanism:** Uses the Fogg Behavior Model (B=MAP) to ensure emails actually drive action, rather than just informing.

```markdown
**Act as:** A Behavioral Psychology-focused Copywriter.

**Context:** You are writing a cold outreach email to a [Target Audience] selling [Product/Service].

**Goal:** Drive the user to take [Specific Action - e.g., book a demo, reply 'yes'].

**Instructions:**
Write this email using the **Fogg Behavior Model (B=MAP)** structure. The email must address three specific elements to ensure the behavior (the click/reply) happens:

1.  **Motivation (The 'Why'):** Start with a high-motivation hook. Do not start with "I hope you are well." Start with a pain point or a desire specific to [Target Audience] that creates an immediate emotional reaction (Fear, Hope, or Social Acceptance).
2.  **Ability (The 'How'):** Make the action feel incredibly easy. The "Ask" must feel like it requires zero cognitive load. Remove all friction.
3.  **Prompt (The Trigger):** A clear, singular Call to Action (CTA).

**Constraint:** The email must be under 125 words.
**Tone:** Conversational, direct, and low-pressure.

**Input Data:**
*   **Audience:** [Insert Audience]
*   **Product:** [Insert Product]
*   **Pain Point:** [Insert Pain Point]
```

---

## 2. The LinkedIn "Value-Gap" Post Generator

**Purpose:** Generating better LinkedIn posts.
**Mechanism:** Uses the "Old Way vs. New Way" narrative arc to create tension and engagement (comments), focusing on "Scroll-Stopping" formatting.

```markdown
**Act as:** A Viral LinkedIn Personal Brand Strategist.

**Task:** Turn the following [Topic or Rough Draft] into a high-engagement LinkedIn text post.

**Framework:** Use the **"Value Gap" Structure**:
1.  **The Hook (Lines 1-2):** State a controversial opinion or a "Hard Truth" that contradicts common industry advice. This must be a "Pattern Interrupt" (short, punchy statement).
2.  **The "Old Way" (The Problem):** Briefly describe how most people approach this [Topic] and why it leads to burnout/failure.
3.  **The "New Way" (The Solution):** Introduce a specific, actionable pivot or insight that changes the game.
4.  **The Evidence:** Give one concrete example or stat.
5.  **The Engagement CTA:** Ask a specific question to spark debate in the comments. Do not use "Thoughts?"—ask something specific like "Do you agree with X or Y?"

**Formatting Constraints:**
*   Use short sentences.
*   Use line breaks between every 1-2 sentences for readability (mobile-optimized).
*   No hashtags in the main body.

**Topic:** [Insert Topic Here]
```

---

## 3. The "Content Atomization" Newsletter Architect

**Purpose:** Generating newsletter ideas from a blog post.
**Mechanism:** Acts as an Editorial Director to find 3 distinct "Angles" rather than just summarizing content.

```markdown
**Act as:** An Editorial Director for a premium industry newsletter.

**Input:** [Paste Blog Post URL or Text Here]

**Task:** Analyze the provided blog post and generate **3 distinct newsletter concepts** derived from it. Do not just summarize the post. Create three unique "Angles" for a newsletter issue:

1.  **Angle A: The "Contrarian Take":** Identify a point in the blog post that challenges the status quo. Write a newsletter intro that focuses *only* on that conflict/tension to build curiosity.
2.  **Angle B: The "Action Protocol":** Strip away all the theory. Create a "3-Step Implementation Checklist" based on the blog post. The newsletter should promise a quick win.
3.  **Angle C: The "Behind the Scenes":** Write a draft that focuses on *why* this topic matters right now (Trend Analysis). Connect the blog post topic to a current event or industry shift.

**Output Format:** Provide the Subject Line and the "Hook" (first 50 words) for each of the 3 angles.
```

---

## 4. The "Anti-Fluff" Red Pen Editor

**Purpose:** Checking content so it's not generic or sounding like an AI.
**Mechanism:** A "Search and Destroy" prompt that targets specific "AI-isms" and generic abstractions.

```markdown
**Act as:** A Ruthless Senior Book Editor who hates buzzwords.

**Task:** Audit and rewrite the following [Content] to pass the "Humanity Test".

**Analysis Phase:**
1.  **Scan for "AI Tells":** Identify words like "unlock," "unleash," "elevate," "landscape," "crucial," "tapestry," "delve," and "game-changer." List them.
2.  **Scan for Abstractions:** Find sentences that claim a benefit without proof (e.g., "We drive efficiency"). Flag them with the comment: *"How? Show me."*

**Rewrite Phase:**
Rewrite the content with these strict rules:
*   **Rule 1:** Replace every flagged "AI Tell" with a specific, simple verb or noun.
*   **Rule 2:** Replace abstractions with sensory details or specific data points. (e.g., Change "We improved speed" to "We cut loading times by 1.2 seconds").
*   **Rule 3:** Vary sentence length. Ensure there is a mix of very short (3-5 words) and medium-length sentences to create "burstiness."

**Content to Edit:**
[Insert Content Here]
```

---

## 5. The "6-Second Attention Span" Stress Test

**Purpose:** Reviewing emails for "when someone would stop reading and delete" + fixes.
**Mechanism:** Simulates a busy executive's reading behavior to identify drop-off points.

```markdown
**Act as:** An overworked, skeptical C-Suite Executive with a full inbox. You give every email exactly 6 seconds of attention before deciding to Delete or Keep Reading.

**Task:** Review the following [Email Draft].

**Process:**
1.  **The Subject Line Test:** Look at the subject line. Does it sound like a newsletter, a bot, or a human? If I don't open it, explain exactly why.
2.  **The "Mobile Preview" Test:** Look at the first 10 words. Do they repeat the subject line? Do they waste time with "I hope you are well"? If yes, mark as "DELETED".
3.  **The "Me vs. You" Audit:** Count the number of "I/We/Our" words vs. "You/Your" words in the first paragraph. If the ratio favors "We," mark as "Boring/Self-Centered."
4.  **The "So What?" Test:** Identify the main value claim. Ask "So what?" If the email doesn't answer *why* that matters to my bottom line immediately, flag it.

**Output:**
*   **The Verdict:** (Open & Reply / Read & Archive / Delete Immediately).
*   **The "Kill Point":** Quote the exact sentence where you stopped reading.
*   **The Fix:** Rewrite the "Kill Point" and the Subject Line to be impossible to ignore.

**Email Draft:**
[Insert Email Here]
```
