# Image Organizer Skill for Gemini CLI

This skill allows Gemini CLI to intelligently organize image files by analyzing their content and renaming them descriptively.

## Features
- **Content-Aware Renaming**: Uses AI to "see" the image and generate a descriptive, kebab-case filename.
- **Automatic Categorization**: Groups images into logical folders (e.g., `UI-Design`, `Marketing`, `Code-Snippets`).
- **Screenshot Cleanup**: Specifically targeted at generic filenames like `Screenshot...` or `Gemini_Generated_Image...`.
- **Smart Source Selection**: Automatically prioritizes a `To-be-named` folder if it exists in the current directory.

## Installation

### For Gemini CLI & Antigravity
1. Download the `image-organizer.skill` file.
2. Open your terminal and run:
   ```bash
   gemini skills install image-organizer.skill --scope user
   ```
3. In your interactive Gemini CLI or Antigravity session, reload your skills:
   ```bash
   /skills reload
   ```

### For Claude Code
1. **Personal Installation**: Copy the `claude-skill` folder to `~/.claude/skills/`.
   ```bash
   cp -r claude-skill ~/.claude/skills/image-organizer
   ```
2. **Project Installation**: Copy the `claude-skill` folder to `.claude/skills/` in your current project.
   ```bash
   mkdir -p .claude/skills
   cp -r claude-skill .claude/skills/image-organizer
   ```
3. Claude will now recognize the `/image-organizer` command and automatically use it when you ask to "organize images."

## Usage

Simply ask the Gemini CLI to organize your images. Examples:
- "Organize my screenshots."
- "Clean up the images in this folder."
- "Look in the To-be-named folder and organize those files."

## Requirements
- Gemini CLI installed and configured.
- Active internet connection for image analysis.
