---
name: image-organizer
description: Organizes image files by renaming them based on content and moving them to categorized folders. Handles generic screenshot and AI-generated filenames.
allowed-tools:
  - read_file
  - list_directory
  - run_shell_command
---

# Image Organizer Skill

This skill helps organize image files by analyzing their content, generating descriptive names, and moving them into appropriate folders.

## Workflow

1.  **Identify Source Directory**:
    *   Check if a `To-be-named` subdirectory exists in the current working directory.
    *   If `To-be-named` exists, use it as the source.
    *   Otherwise, use the current directory as the source.

2.  **Find Generic Images**:
    *   Filter for image files (`.png`, `.jpg`, `.jpeg`, `.webp`, `.gif`) with generic names:
        *   `Screenshot...`
        *   `Screen Recording...`
        *   `Gemini_Generated_Image...`
        *   `Untitled...`
        *   Date/Time strings (e.g., `2026-02-13...`)

3.  **Process Images**:
    *   For each image:
        1.  **Analyze**: Use `read_file` to determine a **Category** (e.g., `Marketing`, `Code`, `UI-Design`) and a **Descriptive Name** (kebab-case).
        2.  **Destination**: 
            *   If source was `To-be-named`, move to `../Category/descriptive-name.ext`.
            *   If source was current dir, move to `./Category/descriptive-name.ext`.
        3.  **Action**: Create the category directory if it doesn't exist (`mkdir -p`) and move the file (`mv`).

4.  **Completion**:
    *   Provide a summary of all files moved and renamed.
