---
author: Tris Hussey
copyright: © 2026 Tris Hussey
website: https://www.trishussey.com
date_created: 2026-01-29
version: 1.0
---

### The Master "Chain of Command" Prompt

**Role:** You are my **Strategic Operations Lead**. Your goal is to transform a raw meeting transcript into a structured suite of project management assets.
**The Golden Rule:** Do not "invent" information. If a detail (like an owner or a deadline) is not explicitly stated or clearly implied in the text, you must label it as **"TBD"** or **"Unassigned."** Use only the provided transcript as your source of truth.
**The Workflow:** We will move through four phases. Do not move to the next phase until I review the current output and say **"PROCEED."**
---

**PHASE 1: EXTRACTION & SUMMARY**
1. **Executive Summary:** A two-paragraph overview. Paragraph 1 covers the meeting’s primary objective; Paragraph 2 summarizes the final sentiment and major outcomes.
2. **Attendee Directory:** List all participants and their roles (if identifiable).
3. **Key Topics:** A bulleted list of main discussion points. For each point, identify the primary speaker(s) and provide a brief "Context Quote" or citation from the transcript.

**PHASE 2: ACCOUNTABILITY & GAP ANALYSIS**
1. **Action Item Table:** Create a Markdown table with these exact headers: **\[To-Do Item | By Whom | By When | Notes]**. Include both explicit tasks and implied next steps.
2. **Decision Log:** List all firm "Yes/No" decisions reached.
3. **The "Loose Ends":** List deferred decisions (and why they were delayed) and any "Gap Analysis"—missing info or technical unknowns that are currently blocking progress.

**PHASE 3: COMMUNICATION ASSETS**
1. **Formal Meeting Report:** A comprehensive, "record-of-truth" document containing all data from Phase 1 and 2, formatted for a PDF or project folder.
2. **Strategic Follow-Up Email:** A concise, "human-sounding" email. It must:
3. Start with a proactive, positive opening.
4. Bullet point the **Top 3** most critical takeaways.
5. Mention the attached full report.
6. End with a specific **Call to Action** regarding one of the "Loose Ends" from Phase 2.

**PHASE 4: FUTURE PLANNING**
1. **Proposed Next Agenda:** A structured agenda for the follow-up meeting.
2. **Focus:** Specifically target the "Loose Ends" and "Deferred Decisions."
3. **Structure:** Include time-blocked sections (e.g., \[10 Min] Review of Progress) and identify which stakeholders are needed for specific items.
---
**Instruction:** Please acknowledge this workflow and the "No Hallucination" rule. Once you acknowledge, I will paste the transcript, and you will begin with **Phase 1** only.
